/**
  *
  * Beschreibung
  *
  * @version 1.0 vom 11.02.2018
  * @author 
  */

public class Wettkampfverwalter {
  
  // Anfang Attribute
  private int aktuelleWettkampfID = 0;
  private DatabaseConnector datenbank;
  private List <Teilnehmer> aktuelleTeilnehmer;
  private Anzeige wettkampfAnzeige;
  private String ausgabe;
  // Ende Attribute
  
  public Wettkampfverwalter(DatabaseConnector datenbank, Anzeige wAnzeige) {
    this.datenbank = datenbank;
    this.aktuelleTeilnehmer = null;
    wettkampfAnzeige = wAnzeige;
    ausgabe = "";
  }

  // Anfang Methoden

  public void ladeWettkampfgruppe(int pWettkampfID, int pGruppeID) {
    ausgabe = ausgabe + "====================>> \n";
    ausgabe = ausgabe + "Wettkampf: " + pWettkampfID + " Gruppe: " + pGruppeID +" \n";
    ausgabe = ausgabe + "====================>> \n \n";
    // Neue leere Liste anlegen.
    aktuelleTeilnehmer = new List<Teilnehmer>();
    // Wert von pWettkampfID in aktuelleWettkampfID speichern.
    aktuelleWettkampfID = pWettkampfID;
    // SQL-Anweisung wird als String vorbereitet.
    String sql = "SELECT Teilnehmer.TeilnehmerID, Teilnehmer.Vorname, "
       + " Teilnehmer.Nachname " + "FROM Teilnehmer "
       + " INNER JOIN nimmtTeil "
       + " ON Teilnehmer.TeilnehmerID = nimmtTeil.TeilnehmerID "
       + " INNER JOIN Wettkampf "
       + " ON nimmtTeil.WettkampfID = Wettkampf.WettkampfID "
       + " INNER JOIN Gruppe "
       + " ON Teilnehmer.GruppeID = Gruppe.GruppeID "
       + "WHERE Gruppe.GruppeID = " + pGruppeID + " AND "
                              + " Wettkampf.WettkampfID = "+ pWettkampfID;
    /* SQL-Anweisung wird an die Datenbank uebermittelt.
    * Das Ergebnis wird in sqlErgebnis gespeichert. */
    datenbank.executeStatement(sql);
    QueryResult sqlErgebnis = datenbank.getCurrentQueryResult();
    /* Datensaetze der Ergebnistabelle werden durchlaufen.
    * Fuer jeden Datensatz wird ein entsprechendes Objekt
    * vom Typ Teilnehmer erzeugt und in die Liste eingefuegt. */
    for (int i = 0; i < sqlErgebnis.getRowCount(); i++) {
      String[] aktZeile = sqlErgebnis.getData()[i];
      Teilnehmer aktTeilnehmer = new Teilnehmer( Integer.parseInt(aktZeile[0]), aktZeile[1], aktZeile[2]);
      aktuelleTeilnehmer.append(aktTeilnehmer);
      ausgabe = ausgabe + aktZeile[0] +" - "+  aktZeile[1] +" - "+ aktZeile[2] + "\n";
    }
    //wettkampfAnzeige.zeigeAn(ausgabe);
    zeigeWettkampfgruppeAn();
  }

  public void aktualisiereZeit(int pTeilnehmerID, int pZeit) {
   
    // Objekt des zu aktualisierenden Teilnehmers suchen.
    Teilnehmer akt = gibTeilnehmer(pTeilnehmerID);
    if (akt == null)  wettkampfAnzeige.zeigeAn("Fehler Teilnehmer fehlt ");
      
    // Aktualisieren, wenn Teilnehmer existiert und keine oder
    // laengere Zeit eingetragen hat.
    if (akt != null && (akt.gibZeit() == 0 || akt.gibZeit() > pZeit)) {
      akt.setzeZeit(pZeit);
      aktuelleTeilnehmer.remove();
      // Teilnehmerobjekt neu einsortieren.
      aktuelleTeilnehmer.toFirst();
      while (aktuelleTeilnehmer.hasAccess()
            && aktuelleTeilnehmer.getContent().gibZeit() != 0
            && aktuelleTeilnehmer.getContent().gibZeit() <= akt.gibZeit()) {
        aktuelleTeilnehmer.next();
      }
      if (aktuelleTeilnehmer.hasAccess()) {
        aktuelleTeilnehmer.insert(akt);
      } else {
        aktuelleTeilnehmer.append(akt);
      }
      
      zeigeWettkampfgruppeAn();
    }
    
  }
    

  public void tueEtwas() {
    aktuelleTeilnehmer.toFirst();
    while (aktuelleTeilnehmer.hasAccess() && aktuelleTeilnehmer.getContent().gibZeit() != 0) {
      Teilnehmer akt = aktuelleTeilnehmer.getContent();
      String s = "UPDATE nimmtTeil SET Ergebniszeit = " + akt.gibZeit()
         + " WHERE TeilnehmerID = " + akt.gibID() + " AND WettkampfID = " + aktuelleWettkampfID;
         datenbank.executeStatement(s); wettkampfAnzeige.zeigeAn(datenbank.getErrorMessage());
         aktuelleTeilnehmer.next();
    }
    
  }

  public Teilnehmer gibTeilnehmer(int pTeilnehmerID) {
    aktuelleTeilnehmer.toFirst();
    while (aktuelleTeilnehmer.hasAccess()
            && aktuelleTeilnehmer.getContent().gibID() != pTeilnehmerID) {
      aktuelleTeilnehmer.next();
    }
    if (aktuelleTeilnehmer.hasAccess()) {
        return aktuelleTeilnehmer.getContent();
      } else {
        return null;
      }
   
  }
  
  public void zeigeWettkampfgruppeAn (){
    Teilnehmer akt= null;
    
    ausgabe = "========== Tabelle ==== Wettkampf: " + aktuelleWettkampfID + " === \n \n";
    aktuelleTeilnehmer.toFirst();
    while (aktuelleTeilnehmer.hasAccess()) {
        akt = aktuelleTeilnehmer.getContent();
        ausgabe = ausgabe + akt.gibNachname() + ", "+ akt.gibVorname() + " : " + akt.gibZeit() + "\n";
        aktuelleTeilnehmer.next();
      }
      
    wettkampfAnzeige.zeigeAn(ausgabe);
  }

  // Ende Methoden
} // end of Wettkampfverwalter

